#version 130
#extension GL_EXT_gpu_shader4 : enable
// the version and open GL extension
// should be the first line of the shader
/////////////////////////////////////////////////////////////////////////////////
//Branchless Voxel Raycasting TexMod01.fsh   by   theraot   
//https://www.shadertoy.com/view/fttXRN
//Licence : Creative Commons Attribution-ShareAlike 4.0
//http://creativecommons.org/licences/by-sa/4.0
// Adapted, trivialy, for use in VGHD player
/////////////////////////////////////////////
uniform float u_Elapsed;    // The elapsed time in seconds
uniform vec2  u_WindowSize; // Window dimensions in pixels

#define iTime u_Elapsed*0.314159  //*0.1666
#define iResolution u_WindowSize

//#define mouse AUTO_MOUSE
//#define MOUSE_SPEED vec2(vec2(0.5,0.577777) * 0.25)
//#define MOUSE_POS   vec2((1.0+cos(iTime*MOUSE_SPEED))*u_WindowSize/2.0)
//#define MOUSE_PRESS vec2(0.0,0.0)
//#define AUTO_MOUSE  vec4( MOUSE_POS, MOUSE_PRESS )
//#define RIGID_SCROLL
// alternatively use static mouse definition
#define iMouse vec4(0.0,0.0, 0.0,0.0)
//#define iMouse vec4(512,256,180,120)
uniform sampler2D texture0;
uniform sampler2D texture1;
uniform sampler2D texture2;
uniform sampler2D texture3;
vec4 texture2D_Fract(sampler2D sampler,vec2 P) {return texture2D(sampler,fract(P));}
vec4 texture2D_Fract(sampler2D sampler,vec2 P, float Bias) {return texture2D(sampler,fract(P),Bias);}
#define texture2D texture2D_Fract

#define PI 3.1415926

// Helper functions for the camera transform

mat4 rotate_xz(float t)
{
    return mat4(
        cos(t) , 0.0, sin(t), 0.0,
        0.0    , 1.0, 0.0   , 0.0,
        -sin(t), 0.0, cos(t), 0.0,
        0.0    , 0.0, 0.0   , 1.0
    );
}

mat4 translate (vec3 v)
{
    return mat4(1.0, 0.0, 0.0, 0.0,
                0.0, 1.0, 0.0, 0.0,
                0.0, 0.0, 1.0, 0.0,
                v.x, v.y, v.z, 1.0); 
}

// Helper functions for voxel geometry

float sdSphere(vec3 p, float d)
{ 
    return length(p) - d;
} 

float sdBox( vec3 p, vec3 b )
{
    vec3 d = abs(p) - b;
    return min(max(d.x,max(d.y,d.z)),0.0) + length(max(d,0.0));
}

float getVoxel(vec3 c) {
	vec3 p = c + vec3(0.5);
	float d = min(max(-sdSphere(p, 7.5), sdBox(p, vec3(6.0))), -sdSphere(p, 25.0));
    return step(0.0, -d);
}

// Main

#define MAX_RAY_STEPS 128

//void mainImage( out vec4 fragColor, in vec2 fragCoord )
///////////////////////////////////////////////////////////////////////////////// 
// need to convert this from a void to a function and call it by adding
// a void main(void) { to the end of the shader
// what type of variable will the function return?, it is a color and needs to be a vec4
// change void to vec4 
//void MainImage(out vec4 fragColor, in vec2 fragCoord) 
vec4 mainImage( out vec4 fragColor, in vec2 fragCoord )
{  
    // Basic setup:
    float aspect = iResolution.x / iResolution.y;
    vec2 screenPos = (fragCoord.xy / iResolution.xy) * 2.0 - 1.0; 
    vec3 rayDir = normalize(vec3(screenPos.x, screenPos.y * (1.0/aspect), 1.0));
    vec3 rayPos = vec3(0.0, 0.0, 0.0);
    
    // Camera transform:
    float verticalOscilation = sin(iTime * 2.7) * 0.0;
    float orbitDistance = 14.0;
    float orbitAngle = (iTime / 5.0);
    mat4 cam_position = translate(vec3(0.0, verticalOscilation, orbitDistance));
    mat4 orbit = rotate_xz(orbitAngle);
    mat4 look = rotate_xz(orbitAngle + PI);
    rayPos = (orbit * cam_position * vec4(rayPos, 1.0)).xyz;
    rayDir = (look * vec4(rayDir, 1.0)).xyz;

    // Voxel traversal setup:
    vec3 raySgn = sign(rayDir);
    vec3 next = floor(rayPos) + clamp(raySgn, 0.0, 1.0);
    vec3 lengthBetween = raySgn / rayDir;
    
    // Vext traversal (first step unrolled):
    vec3 current = rayPos;
    vec3 lengthToNext = (next - rayPos) / rayDir;
    float voxel = getVoxel(floor(current));
    vec3 mask = step(0.0, min(lengthToNext.yzx, lengthToNext.zxy) - lengthToNext.xyz);   
    vec3 lastMask; // This allows me to keep the last mask even without shortcircuiting the loop.
    
    for (int i = 0; i < MAX_RAY_STEPS; i++)
    {
        vec3 effectiveMask = (1.0 - voxel) * mask;
        current += effectiveMask * raySgn;
        lengthToNext += effectiveMask * lengthBetween;
        voxel = sign(voxel + getVoxel(floor(current)));
        // if (voxel == 1.0) break;
        mask = step(0.0, min(lengthToNext.yzx, lengthToNext.zxy) - lengthToNext.xyz);
        lastMask = mask * (1.0 - voxel) + lastMask * (voxel);
    }
    
    // Correct position (the above code does integer steps):
    lengthToNext = lengthToNext - lastMask * lengthBetween; // Step back once
    float traversedLength = min(lengthToNext.x, min(lengthToNext.y, lengthToNext.z));
    current = rayPos + rayDir * traversedLength;
    
    // Compute UV (we use the fractional part of the position): 
    vec3 f = current - floor(current);
    vec2 uv = lastMask.x * f.yz + lastMask.y * f.xz + lastMask.z * f.xy;

    // Texture:
    vec3 color = texture2D(texture0, uv).rgb;
    
    // Shade: 
    color *= vec3(dot(lastMask, vec3(0.5, 1.0, 0.75)));
    
    // Fog:
    vec3 fogcolor = vec3(0.25, 0.4, 0.5);
    color *= mix(fogcolor, color, exp(-traversedLength * traversedLength / 200.0));
    
    // Output:
	fragColor.rgb = color;
/////////////////////////////////////////////////////////////////////////////////
//the function needs to return a value. 
//it needs to be a vec4
//we will return the varable fragColor 
// usual place for fragColor = vec4( color, 1.0 ); bring the } down below
return fragColor; 
}

///////////////////////////////////////////////////////////////////////////////// 
void main(void) { // this will be run for every pixel of gl_FragCoord.xy
vec4 vTexCoord = gl_TexCoord[0];
vec4 fragColor = vec4(1.0); // initialize variable fragColor as a vec4 
vec4 cc = mainImage(fragColor, gl_FragCoord.xy); // call function mainImage and assign the return vec4 to cc
gl_FragColor = vec4(cc) * gl_Color; // set the pixel to the value of vec4 cc  and..
gl_FragColor.a = length(gl_FragColor.rgb)*6.7;
gl_FragColor.g = length(gl_FragColor.rgb)*1.2;
gl_FragColor.r = length(gl_FragColor.rgb)*1.2;

}

// ..uses the values of any Color: or Opacity:
// clauses (and any Animate clauses applied to these properties) 
// appearing in the Sprite, Quad or other node invoking the shader 
// in the .scn file.

